import { ErrorBase } from "./base.error";

const MANUAL_ABORT_ERROR_NAME = 'MANUAL_ABORT_ERROR' as const

export class ManualAbortError extends ErrorBase<typeof MANUAL_ABORT_ERROR_NAME> {
    constructor(cause?: unknown) {
        super({
            name: MANUAL_ABORT_ERROR_NAME,
            message: "ManualAbortError: Request was manually aborted",
            cause: cause,
        })
    }
}